<?php if( $this->isStyled === true ) { ?>
<style>
.pg--wrapper {
    margin: 0 auto; padding: 0;
    width: 100%; max-width: 1024px;
}
.pg--wrapper.pg--request .pg--button {
    display: block;
    appearance: none;
    font-size: 1.25rem; font-weight: bold; color: #fff; text-align: center; text-decoration: none;
    background-color: #c1272c;
    width: 100%;
    padding: 1rem 0;
    border: 0; border-bottom: .125rem solid #911c1f;
    box-shadow: none;
    cursor: pointer;
}
.pg--wrapper.pg--request .pg--agreement-box {
    margin-bottom: 0.5rem;
}
.pg--wrapper.pg--request .pg--paymentmethods {
    margin-bottom: 0.5rem;
}
.pg--wrapper.pg--request .pg--paymentmethods select {
    width: 100%; font-size: 1rem; padding: 1rem;
}
.pg--wrapper.pg--request .pg--summary {
    border: 2px solid #dddddd;
    padding: 1rem; margin-bottom: 1rem;
}
.pg--wrapper.pg--request .pg--summary ul {
    list-style: none;
    margin: 0; padding: 0;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__item {
    border-bottom: 1px dotted #dddddd;
    padding-bottom: 1rem; margin-bottom: 1rem;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__item:last-child {
    border-bottom: 0;
    padding-bottom: 0; margin-bottom: 0;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__title {
    font-size: 1rem; font-weight: normal; color: #555555; line-height: 1;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__body {
    font-size: 1.25rem; font-weight: normal; color: #000000; line-height: 1; text-align: right;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__item.pg--item__price .pg--summary__body {
    font-weight: bold;
}
</style>
<?php } ?>

<div class="pg--wrapper pg--request pg--custom">

<?php if( $this->hasSummary === true ) { ?>
<div class="pg--summary">
    <ul>
        <li class="pg--summary__item pg--item__ordernumber">
            <div class="pg--summary__title">주문번호</div>
            <div class="pg--summary__body"><?php echo $this->orderNumber; ?></div>
        </li>
        <li class="pg--summary__item pg--item__buyername">
            <div class="pg--summary__title">구매자 이름</div>
            <div class="pg--summary__body"><?php echo $this->buyername; ?></div>
        </li>
        <li class="pg--summary__item pg--item__buyertel">
            <div class="pg--summary__title">구매자 연락처</div>
            <div class="pg--summary__body"><?php echo $this->buyertel; ?></div>
        </li>
        <li class="pg--summary__item pg--item__buyertel">
            <div class="pg--summary__title">상품명</div>
            <div class="pg--summary__body"><?php echo $this->goodname; ?></div>
        </li>
        <li class="pg--summary__item pg--item__price">
            <div class="pg--summary__title">결제할 금액</div>
            <div class="pg--summary__body"><?php echo number_format($this->price); ?></div>
        </li>
    </ul>
</div>
<?php } ?>

<!-- 이니시스 표준결제 js -->
<?php if( $this->isTestMode === true ) { ?>
<script language="javascript" type="text/javascript" src="https://stgstdpay.inicis.com/stdjs/INIStdPay.js" charset="UTF-8"></script>
<?php } else { ?>
<script language="javascript" type="text/javascript" src="https://stdpay.inicis.com/stdjs/INIStdPay.js" charset="UTF-8"></script>
<?php } ?>
<script type="text/javascript">
<?php if( isset($_GET['close']) ) echo "if (typeof INIStdPay != 'undefined') { parent.INIStdPay.viewOff(); }"; ?>
function pay() {
    let form = document.getElementById('pg--form');
    if( document.getElementsByName('pg--agreement')[0].checked ) {
        form.setAttribute('action', 'https://mobile.inicis.com/smart/payment/');
        form.submit();
    }
    else {
        form.setAttribute('action', '');
        alert('이용약관에 동의해주세요.'); return false;
    }
}
</script>

<form id="pg--form" name="" method="POST" accept-charset="euc-kr">

<div class="pg--paymentmethods">
    <select name="P_INI_PAYMENT">
    <?php foreach( config('paymentgateway.paymethods')['mobile'] as $key => $paymethod ) { ?>
    <option value="<?php echo $key; ?>"><?php echo $paymethod; ?></option>
    <?php } ?>
    </select>
</div>

<div class="pg--agreement-box">
    <label>
        <input type="checkbox" name="pg--agreement" value="1"/>
        주문상품정보 및 <a class="pg--agreement-link" href="https://www.inicis.com/terms" target="_blank" rel="noopener">결제대행 서비스 이용약관</a>에 동의합니다.
    </label>
</div>

<?php /*** 필수 ***/ ?>
<input type="hidden" name="P_MID" value="<?php echo $this->mid; ?>" readonly/>
<input type="hidden" name="P_GOODS" value="<?php echo $this->goodname; ?>" readonly/>
<input type="hidden" name="P_OID" value="<?php echo $this->orderNumber; ?>" readonly/>
<input type="hidden" name="P_AMT" value="<?php echo $this->price; ?>" readonly/>
<input type="hidden" name="P_UNAME" value="<?php echo $this->buyername; ?>" readonly/>
<input type="hidden" name="P_MOBILE" value="<?php echo $this->buyertel; ?>" readonly/>
<input type="hidden" name="P_EMAIL" value="<?php echo $this->buyeremail; ?>" readonly/>
<input type="hidden" name="P_NEXT_URL" value="<?php echo $this->returnUrl ?>" readonly/>
<input type="hidden" name="P_NOTI_URL" value="<?php echo $this->notiUrl ?>" readonly/>

<?php /*** 기본 옵션 ***/ ?>
<input type="hidden" name="P_OFFER_PERIOD" value="<?php echo $this->offerPeriod; ?>" readonly/>
<input type="hidden" name="P_RESERVED" value="<?php echo $this->acceptmethod; ?>" readonly/>

<?php /*** 표시 옵션 ***/ ?>
<input type="hidden" name="P_CHARSET" value="utf8" readonly/>

<?php /*** 결제 수단별 옵션 : 카드(간편결제) ***/ ?>
<input type="hidden" name="P_QUOTABASE" value="<?php echo $this->cardQuotaBase ?>" readonly/>

<?php /*** 결제 수단별 옵션 : 가상계좌 ***/ ?>

<?php /*** 추가 옵션 ***/ ?>
<input type="hidden" name="P_NOTI" value="<?php echo $this->merchantData; ?>" readonly />

<?php /*** 커스텀 필드 ***/ ?>
<?php foreach($pgData->customFields as $key => $value) { ?>
<input type="hidden" name="<?php echo $key; ?>" value="<?php echo $value; ?>" readonly/>
<?php } ?>

</form>

<button class="pg--button" type="button" onclick="pay(); return false;" title="결제 요청">결제 요청</button>

</div>
