<?php if( $pgData->isStyled === true ) { ?>
<style>
.pg--wrapper {
    margin: 0 auto; padding: 0;
    width: 100%; max-width: 1024px;
}
.pg--wrapper.pg--request .pg--button {
    display: block;
    appearance: none;
    font-size: 1.25rem; font-weight: bold; color: #fff; text-align: center; text-decoration: none;
    background-color: #c1272c;
    width: 100%;
    padding: 1rem 0;
    border: 0; border-bottom: .125rem solid #911c1f;
    box-shadow: none;
    cursor: pointer;
}
.pg--wrapper.pg--request .pg--agreement-box {
    margin-bottom: 0.5rem;
}
.pg--wrapper.pg--request .pg--summary {
    border: 2px solid #dddddd;
    padding: 1rem; margin-bottom: 1rem;
}
.pg--wrapper.pg--request .pg--summary ul {
    list-style: none;
    margin: 0; padding: 0;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__item {
    border-bottom: 1px dotted #dddddd;
    padding-bottom: 1rem; margin-bottom: 1rem;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__item:last-child {
    border-bottom: 0;
    padding-bottom: 0; margin-bottom: 0;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__title {
    font-size: 1rem; font-weight: normal; color: #555555; line-height: 1;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__body {
    font-size: 1.25rem; font-weight: normal; color: #000000; line-height: 1; text-align: right;
}
.pg--wrapper.pg--request .pg--summary .pg--summary__item.pg--item__price .pg--summary__body {
    font-weight: bold;
}
</style>
<?php } ?>

<div class="pg--wrapper pg--request pg--custom">

<?php if( $pgData->hasSummary === true ) { ?>
<div class="pg--summary">
    <ul>
        <li class="pg--summary__item pg--item__ordernumber">
            <div class="pg--summary__title">주문번호</div>
            <div class="pg--summary__body"><?php echo $pgData->orderNumber; ?></div>
        </li>
        <li class="pg--summary__item pg--item__buyername">
            <div class="pg--summary__title">구매자 이름</div>
            <div class="pg--summary__body"><?php echo $pgData->buyername; ?></div>
        </li>
        <li class="pg--summary__item pg--item__buyertel">
            <div class="pg--summary__title">구매자 연락처</div>
            <div class="pg--summary__body"><?php echo $pgData->buyertel; ?></div>
        </li>
        <li class="pg--summary__item pg--item__goodname">
            <div class="pg--summary__title">상품명</div>
            <div class="pg--summary__body"><?php echo $pgData->goodname; ?></div>
        </li>
        <li class="pg--summary__item pg--item__price">
            <div class="pg--summary__title">결제할 금액</div>
            <div class="pg--summary__body"><?php echo number_format($pgData->price); ?></div>
        </li>
    </ul>
</div>
<?php } ?>

<!-- 이니시스 표준결제 js -->
<?php if( $pgData->isTestMode === true ) { ?>
<script language="javascript" type="text/javascript" src="https://stgstdpay.inicis.com/stdjs/INIStdPay.js" charset="UTF-8"></script>
<?php } else { ?>
<script language="javascript" type="text/javascript" src="https://stdpay.inicis.com/stdjs/INIStdPay.js" charset="UTF-8"></script>
<?php } ?>
<script type="text/javascript">
<?php if( isset($_GET['close']) ) echo "if (typeof INIStdPay != 'undefined') { parent.INIStdPay.viewOff(); }"; ?>
function pay() {
    if( document.getElementsByName('pg--agreement')[0].checked ) {
        INIStdPay.pay('pg--form');
    }
    else {
        alert('이용약관에 동의해주세요.'); return false;
    }
}
<?php
/** 결제 직전 계산 폼에 사용할 수 있는 금액 변동 및 표시 예제 **/
/*
function pg__formatWithComma(n,r){const t=String(r).split("").reverse(),e=[];return t.forEach(function(r,t,o){e.push(r),(t+1)%n==0&&t+1<o.length&&e.push(",")}),e.reverse().join("")}
function pg__addEventHandler(t,n,e){t.addEventListener?t.addEventListener(n,e,!1):t.attachEvent&&t.attachEvent("on"+n,e)}
function pg__setPrice(price) {
    price = Number(price)|0;
    document.getElementsByClassName('pg--input__price')[0].value = price;
    document.getElementsByClassName('pg--summary__price')[0].innerHTML = pg__formatWithComma(3, price);
    return price;
}
pg__addEventHandler(document, 'DOMContentLoaded', function() {
    pg__addEventHandler(document.getElementsByClassName('pg--input__price')[0], 'change', function() {
        document.getElementsByClassName('pg--summary__price')[0].innerHTML = pg__formatWithComma(3, this.value*1);
    });
});
*/
?>
</script>

<div class="pg--agreement-box">
    <label>
        <input type="checkbox" name="pg--agreement" value="1"/>
        주문상품정보 및 <a class="pg--agreement-link" href="https://www.inicis.com/terms" target="_blank" rel="noopener">결제대행 서비스 이용약관</a>에 동의합니다.
    </label>
</div>
<button class="pg--button" type="button" onclick="pay(); return false;" title="결제 요청">결제 요청</button>

<form id="pg--form" name="" method="POST">
<input type="hidden" name="_token" value="<?php echo csrf_token(); ?>" />

<?php /*** 필수 ***/ ?>
<input type="hidden" name="version" value="1.0" readonly/>
<input type="hidden" name="mid" value="<?php echo $pgData->mid; ?>" readonly/>
<input type="hidden" name="goodname" value="<?php echo $pgData->goodname; ?>" readonly/>
<input type="hidden" name="oid" value="<?php echo $pgData->orderNumber; ?>" readonly/>
<input type="hidden" name="price" value="<?php echo $pgData->price; ?>" readonly/>
<input type="hidden" name="currency" value="<?php echo $pgData->currency; ?>" readonly/>
<input type="hidden" name="buyername" value="<?php echo $pgData->buyername; ?>" readonly/>
<input type="hidden" name="buyertel" value="<?php echo $pgData->buyertel; ?>" readonly/>
<input type="hidden" name="buyeremail" value="<?php echo $pgData->buyeremail; ?>" readonly/>
<input type="hidden" name="timestamp" value="<?php echo $pgData->timestamp ?>" readonly/>
<input type="hidden" name="signature" value="<?php echo $pgData->sign ?>" readonly/>
<input type="hidden" name="returnUrl" value="<?php echo $pgData->returnUrl ?>" readonly/>
<input type="hidden" name="mKey" value="<?php echo $pgData->mKey ?>" readonly/>

<?php /*** 기본 옵션 ***/ ?>
<input type="hidden" name="gopaymethod" value="<?php echo $pgData->paymethod ?>" readonly/>
<input type="hidden" name="offerPeriod" value="<?php echo $pgData->offerPeriod; ?>" readonly/>
<input type="hidden" name="acceptmethod" value="<?php echo $pgData->acceptmethod; ?>" readonly/>

<?php /*** 표시 옵션 ***/ ?>
<input type="hidden" name="languageView" value="<?php echo $pgData->language; ?>" readonly/>
<input type="hidden" name="charset" value="UTF-8" readonly/>
<input type="hidden" name="payViewType" value="<?php echo $pgData->payViewType; ?>" readonly/>
<input type="hidden" name="closeUrl" value="<?php echo $pgData->closeUrl ?>" readonly/>
<input type="hidden" name="popupUrl" value="<?php echo $pgData->popupUrl ?>" readonly/>

<?php /*** 결제 수단별 옵션 : 카드(간편결제) ***/ ?>
<input type="hidden" name="nointerest" value="<?php echo $pgData->cardNoInterestQuota ?>" readonly/>
<input type="hidden" name="quotabase" value="<?php echo $pgData->cardQuotaBase ?>" readonly/>

<?php /*** 결제 수단별 옵션 : 가상계좌 ***/ ?>
<input type="hidden" name="INIregno" value="<?php echo $pgData->INIregno; ?>" readonly/>

<?php /*** 추가 옵션 ***/ ?>
<input type="hidden" name="merchantData" value="<?php echo $pgData->merchantData; ?>" readonly />

<?php /*** 커스텀 필드 ***/ ?>
<?php foreach($pgData->customFields as $key => $value) { ?>
<input type="hidden" name="<?php echo $key; ?>" value="<?php echo $value; ?>" readonly/>
<?php } ?>

</form>

</div>
