<?php

return [
    /**
     * PG 타입 선택
     * inicis, kcp, ...
     */
    'pg' => 'inicis',

    /**
     * PG 타입별 인증키 설정
     */
    'credentials' => [
        'inicis' => [
            'mid' => env('INICIS_MID', 'INIpayTest'),
            'signKey' => env('INICIS_SIGNKEY', 'SU5JTElURV9UUklQTEVERVNfS0VZU1RS'),
            'key' => env('INICIS_KEY', 'ItEQKi3rY7uvDS8l'),
            'iv' => env('INICIS_IV', 'HYb3yQ4f65QL89=='),
        ],
        'kcp' => [
            'site_cd' => null,
            'site_key' => null,
        ],
    ],

    /**
     * 사용할 결제수단
     */
    'paymethods' => [
        'pc' => [
            'card' => '신용카드',
            'bank' => '계좌이체',
            'vbank' => '가상계좌',
        ],
        'mobile' => [
            'card' => '신용카드',
            'bank' => '계좌이체',
            'vbank' => '가상계좌',
        ],
    ],

    /**
     * 영수증 URL
     */
    'receiptUrls' => [
        // 매출전표
        'receipt' => 'https://iniweb.inicis.com/DefaultWebApp/mall/cr/cm/mCmReceipt_head.jsp?noMethod=1&noTid=',
        // 현금영수증
        'cashreceipt' => 'https://iniweb.inicis.com/DefaultWebApp/mall/cr/cm/Cash_mCmReceipt.jsp?clpaymethod=22&noTid=',
    ],

    /**
     * 테스트 모드 설정 (boolean)
     * true = 테스트 모드 / false = 실결제 모드
     * 테스트 모드로 설정하면 테스트용 인증키로 자동 적용된다.
     */
    'testMode' => env('PG_TEST', true),

    /**
     * 기본 CSS 스타일 적용 여부 (boolean)
     * true = 기본 CSS 적용 / false = HTML만 출력
     */
    'isStyled' => true,

    /**
     * 결제 관련 정보 출력 여부 (boolean)
     * true = 결제금액, 주문번호 등 결제정보 출력 / false = 결제하기 버튼만 출력
     */
    'hasSummary' => true,

    /**
     * 커스텀 필드 (array)
     * key => value 일 경우, 결제요청시 <input type="hidden" name="key" value="value"/>로 출력된다.
     */
    'customFields' => [],
];
