# PaymentGateway

![The 2-Clause BSD License (BSD-2-Clause)][ico-license]


## Installation

1. ```composer.json```에 추가
```json
{
  "repositories": [{
    "type": "composer",
    "url": "https://packages.nukim.io"
  }]
}
```

2. Composer로 설치
``` bash
$ composer require citroorder/paymentgateway
```

3. ```VerifyCsrfToken.php``` 수정
- pg 관련 route 예외 추가.
```php
protected $except = [
    'pg/*',
];
```

## Usage

### 동작 프로세스

1. 주문 내역 생성
  - 주문할 상품 목록, 배송비, 고객정보, 할인 등 모든 데이터 정리.
  - 컨트롤러에 넘기며 임시 DB에 저장(권장).
2. 결제 페이지
  - 기본 라우트: ```/pg```
  - HTTP METHOD: ```GET```
  - 위 과정 진행 후 별도 결제페이지로 이동.
  - 결제페이지 띄울 때 아래 예제와 같이 인스턴스 생성하여 폼 출력.
3. 결제 완료 페이지
  - 기본 라우트: ```/pg/return```
  - HTTP METHOD: ```POST```
  - 값을 리턴 받고 유효성 검사를 거친 후 주문완료 과정 진행.

### 예제

* Controller
```php
<?php
namespace App\Http\Controllers;

use Citroorder\PaymentGateway\Inicis;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function request(Request $request)
    {
        $pg = new Inicis;

        $pg->setGateway(config('paymentgateway.pg'));
        $pg->isTestMode(true);

        $pg->setGoodName('예시상품');
        $pg->setBuyer([
            'name' => '홍길동',
            'tel' => '010-1234-1234',
        ]);

        $pg->setPrice('1000');
        $pg->setOrderNumber('test123123');
        $pg->setPaymethod('Card:VBank:DirectBank');
        $pg->setAcceptMethod("SKIN(#189CC3)");

        return view('payment', compact('pg'));
    }
}
```
* Blade View (폼 생성하기 원하는 위치에 삽입)
```php
{!! $pg->requestPayment() !!}
```

### 커스터마이즈

* 설정 파일
```php
$ php artisan vendor:publish citroorder.paymentgateway-config
```
* php 뷰
```php
$ php artisan vendor:publish citroorder.paymentgateway-views
```

## 결제취소

### 동작프로세스
1. 취소 데이터 생성
  - 취소할 상품의 지불수단, 거래번호, 취소사유(옵션) 데이터 정리.
  - 컨트롤러에 데이터 넘기기.
  - 넘어온 데이터를 파라미터로 전달하여 취소 함수 호출.

### 예제
* Controller
```php
<?php

namespace App\Http\Controllers;

use Citroorder\PaymentGateway\Inicis;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    /**
     * 결제취소
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function cancel(Request $request)
    {
        $pg = new Inicis;

        $pgCancelResult = $pg->cancel([
            'paymethod' => 'card', // 지불수단 (필수)
            'tid' => 'StdpayCARDINIpayTest20210312110046287745', // 거래번호 (필수)
            'msg' => '테스트 상품 취소', // 취소사유 (옵션)
        ]);

        // 취소 성공인 경우
        if (strcmp('00', $pgCancelResult['resultCode']) == 0) {
            echo 'Cancel Success: ' . $pgCancelResult['resultMsg'];
        } else {
            echo 'Cancel Fail: ' . $pgCancelResult['resultMsg'];
        }
    }
}
```

## 부분 결제취소

### 동작프로세스
1. 부분취소 데이터 생성
  - 부분취소할 상품의 지불수단, 거래번호, 취소사유(옵션), 취소요청금액, 부분취소 후 남은금액 데이터 정리.
  - 컨트롤러에 데이터 넘기기.
  - 넘어온 데이터를 파라미터로 전달하여 부분취소 함수 호출.

### 예제
* Controller
```php
<?php

namespace App\Http\Controllers;

use Citroorder\PaymentGateway\Inicis;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    /**
     * 부분 결제취소
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function cancelPart(Request $request)
    {
        $pg = new Inicis;

        $pgCancelPartResult = $pg->cancelPart([
            'paymethod' => 'card', // 지불수단 (필수)
            'tid' => 'StdpayCARDINIpayTest20210312110046287745', // 거래번호 (필수)
            'msg' => '테스트 상품 취소', // 취소사유 (옵션)
            'price' => 1000, // 취소요청금액 (필수)
            'confirmPrice' => 0, // 부분취소 후 남은금액 (필수)
        ]);

        // 부분 취소 성공인 경우
        if (strcmp('00', $pgCancelPartResult['resultCode']) == 0) {
            echo 'Cancel Success: ' . $pgCancelPartResult['resultMsg'];
        } else {
            echo 'Cancel Fail: ' . $pgCancelPartResult['resultMsg'];
        }
    }
}

```

## 거래조회

### 동작프로세스
1. 거래조회 데이터 생성
  - 거래조회할 상품의 거래번호 데이터 정리.
  - 컨트롤러에 데이터 넘기기.
  - 넘어온 데이터를 파라미터로 전달하여 거래조회 함수 호출.

### 예제
* Controller
```php
<?php

namespace App\Http\Controllers;

use Citroorder\PaymentGateway\Inicis;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    /**
     * 거래조회
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function inquiry(Request $request)
    {
        $pg = new Inicis;

        $pgInquiryResult = $pg->inquiry([
            'originalTid' => 'StdpayCARDINIpayTest20210312110046287745', // 거래번호 (필수)
        ]);

        // 성공인 경우
        if (strcmp('00', $pgInquiryResult['resultCode']) == 0) {
            echo 'Inquiry Success: ' . $pgInquiryResult['resultMsg'];
        } else {
            echo 'Inquiry Fail: ' . $pgInquiryResult['resultMsg'];
        }
    }
}


```

## Security

If you discover any security related issues, please [email][email-author] instead of using the issue tracker.

## Credits

- [DTWORESOURCE Corp.][link-company]
- [Bruce M. Lim][link-author]

## License

The 2-Clause BSD License (BSD-2-Clause). Please see the [license file](license.md) for more information.

[ico-version]: https://img.shields.io/packagist/v/citroorder/paymentgateway.svg?style=flat-square
[ico-downloads]: https://img.shields.io/packagist/dt/citroorder/paymentgateway.svg?style=flat-square
[ico-travis]: https://img.shields.io/travis/citroorder/paymentgateway/master.svg?style=flat-square
[ico-styleci]: https://styleci.io/repos/12345678/shield
[ico-license]: https://img.shields.io/badge/licence-BSD--2--Clause-black

[link-packagist]: https://packagist.org/packages/citroorder/paymentgateway
[link-downloads]: https://packages.nukim.io/#citroorder/paymentgateway
[link-travis]: https://travis-ci.org/citroorder/paymentgateway
[link-styleci]: https://styleci.io/repos/12345678
[link-author]: https://limminho.com
[link-contributors]: ../../contributors
[link-company]: https://dtwocorp.com
[email-author]: bruce.lim@dtwocorp.com
